/*
 * AgentSetupJFrame.java
 *
 * 
 */
 package DisCSP.CSPApplication;

import javax.swing.*;
import javax.swing.event.*;
import DisCSP.DistributedCSP.*;
import java.awt.event.*;
import java.awt.*;
import java.util.Vector;
import java.io.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */

public class AgentSetupJFrame extends JFrame
{

	JLabel IP;
	JTextField port;
	JTextArea problem;
	JTextField neighVar;
	JTextField neighIP;
	JTextField neighPort;
	DefaultListModel listModel;	
	JList neighList;
	
    String[] agentsIP;
    int[] agentsPort;
    Neighbourhood[] nhoods;
    String[] constrProblems;
	int index;
 
 	/** Costruttore di AgentSetupJFrame
     * 
     * @param name il nome dell'agente
     * @param ind l'indice dell'agente relativamente alla JList
     * @param agIP l'ip dell'agente
     * @param agPort la porta dell'agente
     * @param nh il vicinato dell'agente
     * @param constrProbl il problema associato all'agente
     * @param modeDistr true per distributed mode, false per local mode
     * 
     */		
    public AgentSetupJFrame(String name,int ind,String[] agIP,int[] agPort,Neighbourhood[] nh, String[] constrProbl, boolean modeDistr)
    {
		    
		index=ind;
		agentsIP=agIP;
		agentsPort=agPort;
		nhoods=nh;
		constrProblems=constrProbl;

        
        setResizable(false);
        
        //MenuBar
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        JMenuItem menuFileOpen = new JMenuItem("Open Problem...");
        JMenuItem menuFileSave = new JMenuItem("Save");


        menuFile.add(menuFileOpen);
        menuFile.add(menuFileSave);
        menuBar.add(menuFile);
        setJMenuBar(menuBar);

        setTitle(name+" Setup");
        setSize(new Dimension(400, 600));

 		Box IPBox= new Box(BoxLayout.X_AXIS );
        JLabel IPLabel= new JLabel("IP:   ");
        IP=new JLabel(agentsIP[index],10);
		IPBox.add(IPLabel);
		IPBox.add(IP);
 		Box portBox= new Box(BoxLayout.X_AXIS );
		JLabel portLabel= new JLabel("Port: ");
        port=new JTextField(""+agentsPort[index],5);
        portBox.add(portLabel);
        portBox.add(port);         

			   	
	   	problem= new JTextArea(15,33);
	   	problem.setText(constrProblems[index]);
	   	JScrollPane scrollProblem = new JScrollPane(problem);
		scrollProblem.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollProblem.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS );

	   	
	   	
	   	Box addressBox= new Box(BoxLayout.Y_AXIS );
 		addressBox.add(IPBox);
 		addressBox.add(new JLabel(" "));
		addressBox.add(portBox);
		
		
 		Box neighVarBox= new Box(BoxLayout.X_AXIS );
        JLabel neighVarLabel= new JLabel("Variables: ");
        neighVar=new JTextField("",10);
		neighVarBox.add(neighVarLabel);
		neighVarBox.add(neighVar);		
 		Box neighIPBox= new Box(BoxLayout.X_AXIS );
        JLabel neighIPLabel= new JLabel("IP:   ");
        neighIP=new JTextField("",10);
		neighIPBox.add(neighIPLabel);
		neighIPBox.add(neighIP);
 		Box neighPortBox= new Box(BoxLayout.X_AXIS );
		JLabel neighPortLabel= new JLabel("Port: ");
        neighPort=new JTextField("",5);
        neighPortBox.add(neighPortLabel);
        neighPortBox.add(neighPort);         
 		Box neighButtonBox= new Box(BoxLayout.X_AXIS );
		JButton neighAddButton= new JButton("Add");
		JButton neighRemoveButton= new JButton("Remove");
        neighButtonBox.add(neighAddButton);         
        neighButtonBox.add(neighRemoveButton);         
				
		Box neighAddBox= new Box(BoxLayout.Y_AXIS );
 		neighAddBox.add(neighVarBox);
 		neighAddBox.add(neighIPBox);
 	//	neighAddBox.add(new JLabel(" "));
		neighAddBox.add(neighPortBox);
 		neighAddBox.add(new JLabel(" "));
		neighAddBox.add(neighButtonBox);
		
		listModel=new  DefaultListModel(); 
		neighList= new JList(listModel);
		neighList.setVisibleRowCount(5);
		neighList.setFixedCellWidth(100);
		neighList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION );
		JScrollPane scrollNeighList = new JScrollPane(neighList);
		scrollNeighList.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
		scrollNeighList.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS );
		
		for(int i=0;i<nhoods[index].size();i++)
		{
			listModel.addElement(nhoods[index].neighbourAt(i).printVars() );
		}
		

		Box neighBox= new Box(BoxLayout.X_AXIS );
 		neighBox.add(neighAddBox);
 		neighBox.add(Box.createHorizontalStrut(75));
 		neighBox.add(scrollNeighList);

		menuFileOpen.addActionListener
 		(
 			new ActionListener()
 			{
 				public void actionPerformed (ActionEvent e)
 				{ 				
					JFileChooser chooser = new JFileChooser();
					int returnVal = chooser.showOpenDialog(AgentSetupJFrame.this);
					if(returnVal == JFileChooser.APPROVE_OPTION)
					 {
					      open(chooser.getSelectedFile().getAbsolutePath());
					 }
			
			 	}
 			}
 		);
 		
 		
 		menuFileSave.addActionListener
 		(
 			new ActionListener()
 			{
 				public void actionPerformed (ActionEvent e)
 				{ 				
					AgentSetupJFrame.this.save();
			 	}
 			}
 		);
		
		this.addWindowListener
        (
            new WindowAdapter()
            {
                public void windowClosing(WindowEvent e)
                {                   	
               	   AgentSetupJFrame.this.save();
                }
            }
        ); 		
		
		
		neighAddButton.addActionListener
		(
			new ActionListener()
 			{
 				public void actionPerformed (ActionEvent e)
 				{

					AgentSetupJFrame.this.addNeighbour();
 				}
 			}
		);		

		neighRemoveButton.addActionListener
		(
			new ActionListener()
 			{
 				public void actionPerformed (ActionEvent e)
 				{
					AgentSetupJFrame.this.removeNeighbour();
 				}
 			}
		);
		
		MouseListener mouseListener = new MouseAdapter() 
 		{
    		public void mouseClicked(MouseEvent e)
    		{
        		if (e.getClickCount() == 2)
        		{            		
		            String varLine=(String) neighList.getSelectedValue();
											
					for(int i=0;i<nhoods[index].size();i++)
					{
						if(varLine.equals(nhoods[index].neighbourAt(i).printVars() ) )
						{
							
							neighVar.setText(varLine);
							neighIP.setText(nhoods[index].neighbourAt(i).addressString());
							neighPort.setText(""+nhoods[index].neighbourAt(i).port());
							break;
						}
					}

         		}
    		}
		};
		
		neighList.addMouseListener(mouseListener);
				
		if(!modeDistr)
		{
			neighAddButton.setEnabled(false);
		}
		
 		JPanel addressPanel = new JPanel();
 		addressPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),"Agent Location"));
 		addressPanel.add(addressBox);
 		
 		JPanel neighPanel = new JPanel();
 		neighPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),"Neighbourhood"));
 		neighPanel.add(neighBox);

  		JPanel problemPanel = new JPanel();
 		problemPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),"Constraint Problem"));
 		problemPanel.add(scrollProblem);

 		
 		Box tot= new  Box(BoxLayout.Y_AXIS);
  		tot.add(problemPanel);
		tot.add(neighPanel);
		tot.add(addressPanel);
		
		this.getContentPane().add(tot);
 	
        this.validate();

    }
    
	
	private void save()
	{
		agentsIP[index]=IP.getText();
		agentsPort[index]=new Integer(port.getText()).intValue();
		constrProblems[index]=problem.getText();
	}
	
	private void open(String nFile)
	{
	 	
	 	try
	 	{
 			FileReader fin=new FileReader(nFile);
 			BufferedReader din=new BufferedReader (fin);
 			String content="";
 			String app=din.readLine();
 			while(app!=null)
 			{
 				content+=app +"\n";
 				app=din.readLine();
 			}
 			din.close();
 			fin.close();
 			problem.setText(content);	
		}
 		catch (Exception e)
 		{
		}
	}
	
	
	private void addNeighbour()
	{		
		try
		{
			String[] var=neighVar.getText().split(",");
			
			nhoods[index].addElement( new Neighbour(var,neighIP.getText(),new Integer(neighPort.getText()).intValue()) );
			
			listModel.addElement(nhoods[index].neighbourAt( nhoods[index].size()-1 ).printVars()); 

		}
		catch(Exception e)
		{
		}

		
	}

	private void removeNeighbour()
	{		
		int sel= neighList.getSelectedIndex();
		
		if(sel!=-1)
		{
			String varLine=(String) neighList.getSelectedValue();
			
			listModel.removeElementAt(sel); 
				
			for(int i=0;i<nhoods[index].size();i++)
			{
				if(varLine.equals(nhoods[index].neighbourAt(i).printVars() ) )
				{
					nhoods[index].removeElementAt(i);
					break;
				}
			}
		}
	}

}